$portobj = Get-WmiObject Win32_SerialPort |                     # List Serial ports
             Select-Object -Property Name, MaxBaudRate |        # Only list names
             Where-Object -Property MaxBaudRate -EQ 115200      # Find Arduino Due (Based on Baud rate)

$n = ($portobj | measure).Count     # Number of ports found

if ($n -eq 0) {   # No devices
  echo "No device found. Please plug in a Bioreactor and try again."
  exit
} elseif ($n -eq 1) {   # Only one device
  $found = $portobj.Name -match "COM[0-9]*"
} elseif ($n -ge 2) {   # Multiple devices - ask for port name
  $portinput = Read-Host "More than one potential device found. Please enter port e.g. COM15"
  $found = $portinput -match "COM[0-9]*"    # Make sure input is valid
}

if (-not $found) {
  echo "Invalid port. Please try again."
  exit
}

$portname = $matches.0
echo "Device found on port $portname. Beginning upload..."

$port = New-Object System.IO.Ports.SerialPort $portname,1200,None,8,one               # Establish connection
$port.open()
$port.close()

.\bossac -i -d --port=$portname -U false -e -w -v -b *.ino.bin -R |                   # Upload .bin
  Select-String -CaseSensitive "Erase.*|done.*|Write.*|Verify.*|CPU.*|\[.+pages\)" |  # Print progress & useful info
  foreach {$_.Matches.Value}

